function dm=LoadDM(filename);
%function dm=LoadDM(filename);
%dm structure = pts, ch, x, y, v, g
% pts = number of points per actuator shape
% ch = channel mapping
% x = x coordinates of actuator shape
% y = y coordinates of actuator shape
% v = voltage
% g = group number
dm=[];
fp=fopen(filename);
if (fp==-1) return; end;
c=1;
while(~feof(fp))
    str=fgets(fp);
    switch(str(1))
        case 'A'
            x=parse(str,',');
            dm(c).pts = x(1);
            dm(c).ch = x(2);
            ind=1;
            for ii=3:2:length(x);
                dm(c).x(ind)=x(ii);
                dm(c).y(ind)=x(ii+1);
                ind=ind+1;
            end;
            c=c+1;
        case 'V'
            x=parse(str,',');
            for ii=1:length(x);
                if (length(dm)>=ii)
                    dm(ii).v=x(ii);
                end;
            end;
        case 'G'
            x=parse(str,',');
            for ii=1:length(x);
                if (length(dm)>=ii)
                    dm(ii).g=x(ii);
                end;
            end;
    end;
end;
fclose(fp);
return;