function SaveDM(filename,dm);
%function SaveDM(filename,dm);
%dm structure = pts, ch, x, y, v, g
% pts = number of points per actuator shape
% ch = channel mapping
% x = x coordinates of actuator shape
% y = y coordinates of actuator shape
% v = voltage
% g = group number
% Example:
% setup;
%
% %generate dm structure
% nf;
% for ii=1:64;
%     xoff = mod(ii-1,8);
%     yoff = floor((ii-1)/8);
%     dm(ii).pts=5;
%     dm(ii).x = xoff + 0.45.*[-1 -1 1 1 -1];
%     dm(ii).y = yoff + 0.45.*[-1 1 1 -1 -1];
%     dm(ii).ch = ii-1;
%     dm(ii).v = 0;
%     dm(ii).g = 0;
%     plot(dm(ii).x,dm(ii).y,getLineSpec(ii));
%     hold on;
% end;
%
% SaveDM('BigStraight.dm',dm);


lineend=sprintf('\n');

fp=fopen(filename,'wt');
if (fp==0)
    error('Cannot open file: %s',filename);
    return;
end;

%actuator definitions
for ii=1:length(dm)
    fprintf(fp,'A,');
    fprintf(fp,'%i,',dm(ii).pts);
    fprintf(fp,'%i,',dm(ii).ch);
    for jj=1:dm(ii).pts;
        fprintf(fp,'%f,%f,',dm(ii).x(jj),dm(ii).y(jj));
    end;
    fprintf(fp,'%s',lineend);
end;

%actuator voltages
fprintf(fp,'V,');
for ii=1:length(dm)
    fprintf(fp,'%i,',dm(ii).v);
end;
fprintf(fp,'%s',lineend);

%actuator groups
fprintf(fp,'G,');
for ii=1:length(dm)
    fprintf(fp,'%i,',dm(ii).g);
end;
fprintf(fp,'%s',lineend);

%COM port information (not used, but legacy)
fprintf(fp,'C,9600,'); fprintf(fp,'%s',lineend);
fprintf(fp,'C,None,');fprintf(fp,'%s',lineend);
fprintf(fp,'C,8,');fprintf(fp,'%s',lineend);
fprintf(fp,'C,1,');fprintf(fp,'%s',lineend);
fprintf(fp,'C,1,');fprintf(fp,'%s',lineend);
fprintf(fp,'C,255,');fprintf(fp,'%s',lineend);
fclose(fp);

return;
